/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.FileTransferMode;
import org.ggf.drmaa.InvalidArgumentException;
import org.ggf.drmaa.InvalidAttributeFormatException;
import org.ggf.drmaa.PartialTimestamp;
import org.ggf.drmaa.PartialTimestampFormat;
import org.ggf.drmaa.UnsupportedAttributeException;

public class JobTemplate {
    private static final List attributeNames = Arrays.asList("args", "blockEmail", "email", "errorPath", "inputPath", "jobCategory", "jobEnvironment", "jobName", "jobSubmissionState", "joinFiles", "nativeSpecification", "outputPath", "remoteCommand", "startTime", "workingDirectory");
    private List allAttributeNames = null;
    public static final int HOLD = 0;
    public static final int ACTIVE = 1;
    public static final String HOME_DIRECTORY = "$drmaa_hd_ph$";
    public static final String WORKING_DIRECTORY = "$drmaa_wd_ph$";
    public static final String PARAMETRIC_INDEX = "$drmaa_incr_ph$";
    protected String remoteCommand = null;
    protected String[] args = null;
    protected int state = 1;
    protected Properties env = null;
    protected String wd = null;
    protected String category = null;
    protected String spec = null;
    protected String[] email = null;
    protected boolean blockEmail = false;
    protected PartialTimestamp startTime = null;
    protected String name = null;
    protected String inputPath = null;
    protected String outputPath = null;
    protected String errorPath = null;
    protected boolean join = false;

    public void setRemoteCommand(String remoteCommand) throws DrmaaException {
        this.remoteCommand = remoteCommand;
    }

    public String getRemoteCommand() {
        return this.remoteCommand;
    }

    public void setArgs(String[] args) throws DrmaaException {
        if (args != null) {
            this.args = new String[args.length];
            System.arraycopy(args, 0, this.args, 0, args.length);
        } else {
            this.args = null;
        }
    }

    public String[] getArgs() {
        if (this.args != null) {
            String[] returnValue = new String[this.args.length];
            System.arraycopy(this.args, 0, returnValue, 0, this.args.length);
            return returnValue;
        }
        return null;
    }

    public void setJobSubmissionState(int state) throws DrmaaException {
        if (state != 1 && state != 0) {
            throw new InvalidArgumentException("Invalid state");
        }
        this.state = state;
    }

    public int getJobSubmissionState() {
        return this.state;
    }

    public void setJobEnvironment(Properties env) throws DrmaaException {
        this.env = env != null ? (Properties)env.clone() : null;
    }

    public Properties getJobEnvironment() {
        if (this.env != null) {
            return (Properties)this.env.clone();
        }
        return null;
    }

    public void setWorkingDirectory(String wd) throws DrmaaException {
        if (wd.indexOf(HOME_DIRECTORY) > 0) {
            throw new InvalidAttributeFormatException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (wd.indexOf(WORKING_DIRECTORY) >= 0) {
            throw new InvalidAttributeFormatException("$drmaa_wd_ph$ may not be used in the workingDirectory path.");
        }
        this.wd = wd;
    }

    public String getWorkingDirectory() {
        return this.wd;
    }

    public void setJobCategory(String category) throws DrmaaException {
        this.category = category;
    }

    public String getJobCategory() {
        return this.category;
    }

    public void setNativeSpecification(String spec) throws DrmaaException {
        this.spec = spec;
    }

    public String getNativeSpecification() {
        return this.spec;
    }

    public void setEmail(String[] email) throws DrmaaException {
        if (email != null) {
            this.email = new String[email.length];
            System.arraycopy(email, 0, this.email, 0, email.length);
        } else {
            this.email = null;
        }
    }

    public String[] getEmail() {
        if (this.email != null) {
            String[] returnValue = new String[this.email.length];
            System.arraycopy(this.email, 0, returnValue, 0, this.email.length);
            return returnValue;
        }
        return null;
    }

    public void setBlockEmail(boolean blockEmail) throws DrmaaException {
        this.blockEmail = blockEmail;
    }

    public boolean getBlockEmail() {
        return this.blockEmail;
    }

    public void setStartTime(PartialTimestamp startTime) throws DrmaaException {
        if (startTime != null) {
            if (startTime.getTimeInMillis() < System.currentTimeMillis()) {
                throw new InvalidArgumentException("Start time is in the past.");
            }
            this.startTime = startTime;
        } else {
            startTime = null;
        }
    }

    public PartialTimestamp getStartTime() {
        if (this.startTime != null) {
            return (PartialTimestamp)this.startTime.clone();
        }
        return null;
    }

    public void setJobName(String name) throws DrmaaException {
        this.name = name;
    }

    public String getJobName() {
        return this.name;
    }

    public void setInputPath(String inputPath) throws DrmaaException {
        this.checkPath(inputPath);
        this.inputPath = inputPath;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setOutputPath(String outputPath) throws DrmaaException {
        this.checkPath(outputPath);
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setErrorPath(String errorPath) throws DrmaaException {
        this.checkPath(errorPath);
        this.errorPath = errorPath;
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public void setJoinFiles(boolean join) throws DrmaaException {
        this.join = join;
    }

    public boolean getJoinFiles() {
        return this.join;
    }

    public void setTransferFiles(FileTransferMode mode) throws DrmaaException {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    public FileTransferMode getTransferFiles() {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    public void setDeadlineTime(PartialTimestamp deadline) throws DrmaaException {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    public PartialTimestamp getDeadlineTime() {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    public void setHardWallclockTimeLimit(long hardWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    public long getHardWallclockTimeLimit() {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    public void setSoftWallclockTimeLimit(long softWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    public long getSoftWallclockTimeLimit() {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    public void setHardRunDurationLimit(long hardRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    public long getHardRunDurationLimit() {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    public void setSoftRunDurationLimit(long softRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    public long getSoftRunDurationLimit() {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAttributeNames() {
        JobTemplate jobTemplate = this;
        synchronized (jobTemplate) {
            if (this.allAttributeNames == null) {
                List optionalNames = this.getOptionalAttributeNames();
                this.allAttributeNames = new ArrayList(attributeNames.size() + optionalNames.size());
                this.allAttributeNames.addAll(attributeNames);
                this.allAttributeNames.addAll(optionalNames);
            }
        }
        return this.allAttributeNames;
    }

    protected List getOptionalAttributeNames() {
        return Collections.EMPTY_LIST;
    }

    private void checkPath(String path) throws InvalidArgumentException {
        if (path == null) {
            return;
        }
        if (path.indexOf(HOME_DIRECTORY) > 0) {
            throw new InvalidArgumentException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (path.indexOf(WORKING_DIRECTORY) > 0) {
            throw new InvalidArgumentException("$drmaa_wd_ph$ may only appear at the beginning of the path.");
        }
    }

    public String toString() {
        int count;
        StringBuffer out = new StringBuffer();
        boolean firstProperty = true;
        if (this.getArgs() != null) {
            String[] args = this.getArgs();
            boolean firstArg = true;
            firstProperty = false;
            out.append("{args = ");
            for (count = 0; count < args.length; ++count) {
                if (firstArg) {
                    firstArg = false;
                } else {
                    out.append(", ");
                }
                out.append("\"");
                out.append(args[count]);
                out.append("\"");
            }
            out.append("}");
        }
        if (firstProperty) {
            firstProperty = false;
        } else {
            out.append(" ");
        }
        out.append("{blockEmail = ");
        out.append(Boolean.toString(this.getBlockEmail()));
        out.append("}");
        try {
            if (this.getDeadlineTime() != null) {
                out.append(" {deadlineTime = \"");
                out.append(new PartialTimestampFormat().format(this.getDeadlineTime()));
                out.append("\"}");
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
        if (this.getEmail() != null) {
            String[] email = this.getEmail();
            boolean firstEmail = true;
            out.append(" {email = ");
            for (count = 0; count < email.length; ++count) {
                if (firstEmail) {
                    firstEmail = false;
                } else {
                    out.append(", ");
                }
                out.append("\"");
                out.append(email[count]);
                out.append("\"");
            }
            out.append("}");
        }
        if (this.getErrorPath() != null) {
            out.append(" {errorPath = ");
            out.append(this.getErrorPath());
            out.append("}");
        }
        try {
            if (this.getHardRunDurationLimit() != 0L) {
                out.append(" {hardRunDurationLimit = ");
                out.append(this.getHardRunDurationLimit());
                out.append("ms}");
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
        try {
            if (this.getHardWallclockTimeLimit() != 0L) {
                out.append(" {hardWallclockTimeLimit = ");
                out.append(this.getHardWallclockTimeLimit());
                out.append("ms}");
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
        if (this.getInputPath() != null) {
            out.append(" {inputPath = ");
            out.append(this.getInputPath());
            out.append("}");
        }
        if (this.getJobCategory() != null) {
            out.append(" {jobCategory = ");
            out.append(this.getJobCategory());
            out.append("}");
        }
        if (this.getJobEnvironment() != null) {
            Properties env = this.getJobEnvironment();
            Iterator<Object> i = env.keySet().iterator();
            boolean firstEnv = true;
            out.append(" {jobEnvironment = ");
            while (i.hasNext()) {
                String entry = (String)i.next();
                if (firstEnv) {
                    firstEnv = false;
                } else {
                    out.append(", ");
                }
                out.append("[\"");
                out.append(entry);
                out.append("\" = \"");
                out.append(env.getProperty(entry));
                out.append("\"]");
            }
            out.append("}");
        }
        if (this.getJobName() != null) {
            out.append(" {jobName = ");
            out.append(this.getJobName());
            out.append("}");
        }
        out.append(" {jobSubmissionState = ");
        if (this.getJobSubmissionState() == 0) {
            out.append("HOLD}");
        } else {
            out.append("ACTIVE}");
        }
        out.append(" {joinFiles = ");
        out.append(Boolean.toString(this.getJoinFiles()));
        out.append("}");
        if (this.getNativeSpecification() != null) {
            out.append(" {nativeSpecification = \"");
            out.append(this.getNativeSpecification());
            out.append("\"}");
        }
        if (this.getOutputPath() != null) {
            out.append(" {outputPath = ");
            out.append(this.getOutputPath());
            out.append("}");
        }
        if (this.getRemoteCommand() != null) {
            out.append(" {remoteCommand = ");
            out.append(this.getRemoteCommand());
            out.append("}");
        }
        try {
            if (this.getSoftRunDurationLimit() != 0L) {
                out.append(" {softRunDurationLimit = ");
                out.append(this.getSoftRunDurationLimit());
                out.append("ms}");
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
        try {
            if (this.getSoftWallclockTimeLimit() != 0L) {
                out.append(" {softWallclockTimeLimit = ");
                out.append(this.getSoftWallclockTimeLimit());
                out.append("ms}");
            }
        }
        catch (UnsupportedAttributeException e) {
            // empty catch block
        }
        if (this.getStartTime() != null) {
            out.append(" {startTime = \"");
            out.append(new PartialTimestampFormat().format(this.getStartTime()));
            out.append("\"}");
        }
        try {
            if (this.getTransferFiles() != null) {
                out.append(" {transferFiles = \"");
                out.append(this.getTransferFiles().toString());
                out.append("\"}");
            }
        }
        catch (UnsupportedAttributeException unsupportedAttributeException) {
            // empty catch block
        }
        if (this.getWorkingDirectory() != null) {
            out.append(" {workingDirectory = ");
            out.append(this.getWorkingDirectory());
            out.append("}");
        }
        return out.toString();
    }
}

