/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.drmaa;

import com.sun.grid.drmaa.JobInfoImpl;
import com.sun.grid.drmaa.JobTemplateImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.InvalidJobTemplateException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.Session;
import org.ggf.drmaa.Version;

public class SessionImpl
implements Session {
    private static final String IMPLEMENTATION_STRING = "DRMAA 1.0 Java language binding 0.5 -- ";

    SessionImpl() {
    }

    public void control(String jobId, int action) throws DrmaaException {
        this.nativeControl(jobId, action);
    }

    private native void nativeControl(String var1, int var2) throws DrmaaException;

    public void exit() throws DrmaaException {
        this.nativeExit();
    }

    private native void nativeExit() throws DrmaaException;

    public String getContact() {
        return this.nativeGetContact();
    }

    private native String nativeGetContact();

    public String getDrmSystem() {
        return this.nativeGetDRMSInfo();
    }

    private native String nativeGetDRMSInfo();

    public int getJobProgramStatus(String jobId) throws DrmaaException {
        return this.nativeGetJobProgramStatus(jobId);
    }

    private native int nativeGetJobProgramStatus(String var1) throws DrmaaException;

    public JobTemplate createJobTemplate() throws DrmaaException {
        int id = this.nativeAllocateJobTemplate();
        return new JobTemplateImpl(this, id);
    }

    public void deleteJobTemplate(JobTemplate jt) throws DrmaaException {
        if (jt == null) {
            throw new NullPointerException("JobTemplate is null");
        }
        if (!(jt instanceof JobTemplateImpl)) {
            throw new InvalidJobTemplateException();
        }
        this.nativeDeleteJobTemplate(((JobTemplateImpl)jt).getId());
    }

    public Version getVersion() {
        return new Version(0, 5);
    }

    public void init(String contact) throws DrmaaException {
        this.nativeInit(contact);
    }

    private native void nativeInit(String var1) throws DrmaaException;

    public List runBulkJobs(JobTemplate jt, int start, int end, int incr) throws DrmaaException {
        if (jt == null) {
            throw new NullPointerException("JobTemplate is null");
        }
        if (jt instanceof JobTemplateImpl) {
            String[] jobIds = this.nativeRunBulkJobs(((JobTemplateImpl)jt).getId(), start, end, incr);
            return Arrays.asList(jobIds);
        }
        throw new InvalidJobTemplateException();
    }

    private native String[] nativeRunBulkJobs(int var1, int var2, int var3, int var4) throws DrmaaException;

    public String runJob(JobTemplate jt) throws DrmaaException {
        if (jt == null) {
            throw new NullPointerException("JobTemplate is null");
        }
        if (jt instanceof JobTemplateImpl) {
            return this.nativeRunJob(((JobTemplateImpl)jt).getId());
        }
        throw new InvalidJobTemplateException();
    }

    private native String nativeRunJob(int var1) throws DrmaaException;

    public void synchronize(List jobIds, long timeout, boolean dispose) throws DrmaaException {
        this.nativeSynchronize(jobIds.toArray(new String[jobIds.size()]), timeout, dispose);
    }

    private native void nativeSynchronize(String[] var1, long var2, boolean var4) throws DrmaaException;

    public JobInfo wait(String jobId, long timeout) throws DrmaaException {
        JobInfoImpl jobInfo = this.nativeWait(jobId, timeout);
        return jobInfo;
    }

    private native JobInfoImpl nativeWait(String var1, long var2) throws DrmaaException;

    private native int nativeAllocateJobTemplate();

    native void nativeSetAttributeValue(int var1, String var2, String var3);

    native void nativeSetAttributeValues(int var1, String var2, String[] var3);

    native String[] nativeGetAttributeNames(int var1);

    native String[] nativeGetAttribute(int var1, String var2);

    native void nativeDeleteJobTemplate(int var1);

    public String getDrmaaImplementation() {
        return IMPLEMENTATION_STRING + this.getDrmSystem();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("drmaa");
                return null;
            }
        });
    }
}

