#!/bin/sh -f
# 
#
#___INFO__MARK_BEGIN__
##########################################################################
#
#  The Contents of this file are made available subject to the terms of
#  the Sun Industry Standards Source License Version 1.2
#
#  Sun Microsystems Inc., March, 2001
#
#
#  Sun Industry Standards Source License Version 1.2
#  =================================================
#  The contents of this file are subject to the Sun Industry Standards
#  Source License Version 1.2 (the "License"); You may not use this file
#  except in compliance with the License. You may obtain a copy of the
#  License at http://gridengine.sunsource.net/Gridengine_SISSL_license.html
#
#  Software provided under this License is provided on an "AS IS" basis,
#  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
#  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#  See the License for the specific provisions governing your rights and
#  obligations concerning the Software.
#
#  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
#
#  Copyright: 2001 by Sun Microsystems, Inc.
#
#  All Rights Reserved.
#
##########################################################################
#___INFO__MARK_END__

# stop of MPICH2 conforming with Grid Engine
# parallel environment interface
#
# usage: stopmpich2.sh [options] <pe_hostfile>
#
#        options are:
#                     -catch_rsh
#                      Will remomve the rsh link for the rsh-wrapper.


use_kill=false

#
# shutdown of MPICH2 conforming with Grid Engine
# parallel environment interface
#

#
# we kill smpd's
#

# useful to control parameters passed to us
echo $*
me=`basename $0`

catch_rsh=0
while [ $# -gt 0 ]; do
   case "$1" in
      -catch_rsh)
         catch_rsh=1
         ;;
      *)
         break;
         ;;
   esac
   shift
done

# test number of args
if [ $# -lt 1 ]; then
   echo "$me: got wrong number of arguments" >&2
   exit 1
fi

# get arguments
MPICH2_ROOT=$1

if [ $catch_rsh = 1 ]; then
   rshcmd=rsh
   case "$ARC" in
      hp|hp10|hp11|hp11-64) rshcmd=remsh ;;
      *) ;;
   esac
   rm $TMPDIR/$rshcmd
fi

if [ $use_kill = true ]; then

   pe_hostfile=$1
   host=$2

   pids=`ps -awux | grep smpd |grep -v grep | sed -e "s/[ ][ ]*/:/g" | cut -f2 -d:`
   for p in $pids; do
      echo "$me: killing smpd with pid $p"
      kill $p
   done  

   RSH=/usr/ucb/rsh
   for f in `cut -f1 -d" " $pe_hostfile`; do
      if [ ! $f = $host ]; then
         echo "$me: cleanup on host: $f"
         pids=`$RSH $f 'ps -awux | grep smpd |grep -v grep | sed -e "s/[ ][ ]*/:/g" | cut -f2 -d:'`
         for p in $pids; do
            echo "$me: killing smpd with pid $p"
            $RSH $f "kill $p"
         done  
      fi
   done
else
   port=$((JOB_ID % 5000 + 20000))

   if [ "`$MPICH2_ROOT/bin/smpd -port $port -status $host | head -n 1 | cut -f 1 -d ' '`" == "smpd" ] ; then
      machines=$TMPDIR/machines
# it's intended to be tac and not cat - it's not a typo
      for host in `tac $machines | uniq`; do
         $MPICH2_ROOT/bin/smpd -port $port -shutdown $host
      done

      sleep 5
   fi
fi

rm $TMPDIR/machines

exit 0
